#include <Wire.h>
#include <Arduino.h>
#include <Adafruit_MCP4725.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BNO055.h>
#include <utility/imumaths.h>
#include <WiFi.h>
#include "ThingSpeak.h"

// Define multiplexer address
#define TCAADDR 0x70

// Define imu and dac objects
Adafruit_BNO055 bno = Adafruit_BNO055(55, 0x28);

char jsonBuffer[2000] = "[";

char ssid[] = "";
char pass[] = "";
WiFiClient client;

char server[] = "api.thingspeak.com";

unsigned long lastConnectionTime = 0;
unsigned long lastUpdateTime = 0;
const unsigned long postingInterval = 15L * 1000L;
const unsigned long updateInterval = 1L * 1000L;

// To choose the multiplexer specific channel (between 0 and 7)
void tcaselect(uint8_t i){
  if (i > 7) return;

  Wire.beginTransmission(TCAADDR);
  Wire.write(1 << i);
  Wire.endTransmission();
}

void setup() {
  // put your setup code here, to run once:
  Wire.begin();
  Serial.begin(9600);
  while(!Serial);
  delay(1000);
  Serial.println("Serial communication set up");

  // set up bno055
  tcaselect(2);
  if (!bno.begin()){
    Serial.println("Failed to connect to BNO055");
    while (1);
  }

  while(WiFi.status() != WL_CONNECTED){
    Serial.print("Attempting to connect to wifi");
    WiFi.begin(ssid, pass);
    delay(5000);
  }
  Serial.println("Connected to WiFi");
  printWiFiStatus();
}

void loop() {
  // put your main code here, to run repeatedly.

  if (millis() - lastUpdateTime >= updateInterval){
    updatesJson(jsonBuffer);
  }
}

void updatesJson(char* jsonBuffer){
  /* JSON format for updates paramter in the API
   *  This examples uses the relative timestamp as it uses the "delta_t". You can also provide the absolute timestamp using the "created_at" parameter
   *  instead of "delta_t".
   *   "[{\"delta_t\":0,\"field1\":-70},{\"delta_t\":3,\"field1\":-66}]"
   */

  // Get sensor data
  float dataBuffer[30];
  tcaselect(2);
  for (int i = 0; i <= 29; i ++){
    sensors_event_t orientationData , angVelocityData , linearAccelData, magnetometerData, accelerometerData, gravityData;
    bno.getEvent(&orientationData, Adafruit_BNO055::VECTOR_EULER);
    bno.getEvent(&angVelocityData, Adafruit_BNO055::VECTOR_GYROSCOPE);
    bno.getEvent(&linearAccelData, Adafruit_BNO055::VECTOR_LINEARACCEL);

    float accelX = linearAccelData.acceleration.x;
    dataBuffer[i] = accelX;
    //Serial.println(dataBuffer[i]);
  }
  
  // Format the jsonBuffer as noted above
  strcat(jsonBuffer,"{\"delta_t\":");
  unsigned long deltaT = (millis() - lastUpdateTime) / 100; // time in 100*ms
  size_t lengthT = String(deltaT).length();
  char temp[5];
  String(deltaT).toCharArray(temp,lengthT+1);
  strcat(jsonBuffer,temp);
  strcat(jsonBuffer,",");

  // field1 buffer 
  strcat(jsonBuffer, "\"field1\":");
  strcat(jsonBuffer, "\"");
  float rssi = dataBuffer[0]; 
  lengthT = String(rssi).length();
  String(rssi).toCharArray(temp,lengthT+1);
  strcat(jsonBuffer,temp);
  strcat(jsonBuffer, "/");
  rssi = dataBuffer[1]; 
  lengthT = String(rssi).length();
  String(rssi).toCharArray(temp,lengthT+1);
  strcat(jsonBuffer,temp);
  strcat(jsonBuffer, "/");
  rssi = dataBuffer[2]; 
  lengthT = String(rssi).length();
  String(rssi).toCharArray(temp,lengthT+1);
  strcat(jsonBuffer,temp);
  strcat(jsonBuffer, "/");
  rssi = dataBuffer[3]; 
  lengthT = String(rssi).length();
  String(rssi).toCharArray(temp,lengthT+1);
  strcat(jsonBuffer,temp);
  strcat(jsonBuffer, "\"");
  strcat(jsonBuffer, ",");

  // field2 buffer
  strcat(jsonBuffer, "\"field2\":");
  strcat(jsonBuffer, "\"");
  rssi = dataBuffer[4];
  lengthT = String(rssi).length();
  String(rssi).toCharArray(temp, lengthT+1);
  strcat(jsonBuffer, temp);
  strcat(jsonBuffer, "/");
  rssi = dataBuffer[5];
  lengthT = String(rssi).length();
  String(rssi).toCharArray(temp, lengthT+1);
  strcat(jsonBuffer, temp);
  strcat(jsonBuffer, "\"");
  strcat(jsonBuffer,"},"); // end the buffer as required 
  
  // If posting interval time has reached 15s, update the ThingSpeak channel with your data
  if (millis() - lastConnectionTime >=  postingInterval) {
        size_t len = strlen(jsonBuffer);
        jsonBuffer[len-1] = ']';
        httpRequest(jsonBuffer);
  }
  lastUpdateTime = millis(); // Update the last update time
  dataBuffer[30];
}

// Updates the ThingSpeakchannel with data
void httpRequest(char* jsonBuffer) {
  /* JSON format for data buffer in the API
   *  This examples uses the relative timestamp as it uses the "delta_t". You can also provide the absolute timestamp using the "created_at" parameter
   *  instead of "delta_t".
   *   "{\"write_api_key\":\"YOUR-CHANNEL-WRITEAPIKEY\",\"updates\":[{\"delta_t\":0,\"field1\":-60},{\"delta_t\":15,\"field1\":200},{\"delta_t\":15,\"field1\":-66}]
   */
  // Format the data buffer as noted above
  char data[1000] = "{\"write_api_key\":\"59IISQVOXV5GGH0D\",\"updates\":"; // Replace YOUR-CHANNEL-WRITEAPIKEY with your ThingSpeak channel write API key
  strcat(data,jsonBuffer);
  strcat(data,"}");
  // Close any connection before sending a new request
  client.stop();
  String data_length = String(strlen(data)+1); //Compute the data buffer length
  Serial.println(data);
  Serial.println(data_length);
  // POST data to ThingSpeak
  if (client.connect(server, 80)) {
    client.println("POST /channels/1683708/bulk_update.json HTTP/1.1"); // Replace YOUR-CHANNEL-ID with your ThingSpeak channel ID
    client.println("Host: api.thingspeak.com");
    client.println("User-Agent: mw.doc.bulk-update (Arduino ESP32)");
    client.println("Connection: close");
    client.println("Content-Type: application/json");
    client.println("Content-Length: "+data_length);
    client.println();
    client.println(data);
  }
  else {
    Serial.println("Failure: Failed to connect to ThingSpeak");
  }
  delay(250); //Wait to receive the response
  client.parseFloat();
  String resp = String(client.parseInt());
  Serial.println("Response code:"+resp); // Print the response code. 202 indicates that the server has accepted the response
  jsonBuffer[0] = '['; //Reinitialize the jsonBuffer for next batch of data
  jsonBuffer[1] = '\0';
  lastConnectionTime = millis(); //Update the last conenction time
}

void printWiFiStatus() {
  // Print the SSID of the network you're attached to:
  Serial.print("SSID: ");
  Serial.println(WiFi.SSID());

  // Print your device IP address:
  IPAddress ip = WiFi.localIP();
  Serial.print("IP Address: ");
  Serial.println(ip);

  // Print the received signal strength:
  long rssi = WiFi.RSSI();
  Serial.print("signal strength (RSSI):");
  Serial.print(rssi);
  Serial.println(" dBm");
}
