function [x_axis, y_axis] = create_step_sequence(in, gain)
%%
inter = in(2:end);
change = in;

x_axis = zeros(numel(inter) + numel(change), 1);
y_axis = zeros(numel(inter) + numel(change), 1);

mod_num = 2 * (in(2) - in(1));

%%
out_index = 1;

for i = 1:numel(in)
    if i >= 2
        x_axis(out_index - 1) = inter(i - 1);
        x_axis(out_index) = change(i);

        if mod(in(i), mod_num) == 0
            value = -gain;
        else
            value = gain;
        end
    else
        x_axis(out_index) = change(i);
        value = 0;
    end

    y_axis(out_index) = value;
    out_index = out_index + 1;

    if (out_index < numel(y_axis))
        y_axis(out_index) = value;
        out_index = out_index + 1;
    end
end

end
