function bound_info = calc_phi_dif_bound(loose_bound, tight_bound, ...
    step_sequence_time_vec, step_gain)
%%
dif_min_limit = 1e-6;
step_time = 1;

[x, y] = create_step_sequence(step_sequence_time_vec, step_gain);

%%
bound_info = struct;
bound_info.upper_time = zeros(1, 2);
bound_info.upper_value = zeros(1, 2);
bound_info.lower_time = zeros(1, 2);
bound_info.lower_value = zeros(1, 2);

%%
check_point_time = 0;
check_count = 1;
bound_state = bound_enum.Stable;
loop_count = 1;

while (loop_count <= (numel(y) - 1))
    switch bound_state
        case bound_enum.Stable
            if abs(y(loop_count + 1) - y(loop_count)) > dif_min_limit
                bound_info.upper_time(check_count, :) = ...
                    [check_point_time, x(loop_count)];
                bound_info.lower_time(check_count, :) = ...
                    bound_info.upper_time(check_count, :);

                bound_info.upper_value(check_count, :) = ...
                    tight_bound * ones(1, 2);
                bound_info.lower_value(check_count, :) = ...
                    -tight_bound * ones(1, 2);

                check_point_time = x(loop_count);
                bound_state = bound_enum.Step;
                check_count = check_count + 1;
            end

        case bound_enum.Step
            if (x(loop_count) - check_point_time >= 1)
                
                bound_info.upper_time(check_count, :) = ...
                    [check_point_time, check_point_time + step_time];
                bound_info.lower_time(check_count, :) = ...
                    bound_info.upper_time(check_count, :);

                bound_info.upper_value(check_count, :) = ...
                    loose_bound * ones(1, 2);
                bound_info.lower_value(check_count, :) = ...
                    -loose_bound * ones(1, 2);

                check_point_time = check_point_time + 1;
                bound_state = bound_enum.Stable;
                check_count = check_count + 1;
                loop_count = loop_count - 1;
            end

        otherwise

    end

    loop_count = loop_count + 1;
end

%%


end
