
# <span style="color:rgb(213,80,0)">現場で使える制御設計：周波数応答推定と制御応答最適化</span>
# セミナーアジェンダ

本セッションでは、制御工学を良く知らない初心者の方でも、設計の現場で制御設計ができるようになるソリューションをお伝えします。


制御器を設計する時、線形の制御理論がよく用いられていますが、制御設計の現場では、モーターなど物理特性に非線形な要素を含むシステムも多く存在しており、そのままでは適用が難しい場合があります。


本セッションでは、解析的に線形化することができないシステムに対して周波数応答を推定し、その応答データから線形化する方法について紹介します。


また一方で、非線形システムに対応した最適化法を用いて「ゲインを変えて制御を実行」を繰り返し行うことで、最適なゲインを探索するアプローチもあります。本セミナーでは、その探索によるゲイン最適化手法についても具体例を交えて紹介します。最後に設計した制御器を実機実装し、検証するワークフローについても紹介します。

# 必要なツールボックス
-  MATLAB 
-  Simulink 
-  Simscape 
-  Simscape Electrical 
-  Simscape Multibody 
-  Control System Toolbox 
-  Simulink Control Design 
-  Simulink Design Optimization 
-  Optimization Toolbox 
-  Global Optimization Toolbox 
-  System Identification Toolbox 
# 推奨ツールボックス
-  Parallel Computing Toolbox 
# 必要なサポートパッケージ
-  MATLAB Support Package for Raspberry Pi Hardware 
-  Simulink Support Package for Raspberry Pi Hardware 
# バージョン

R2023b

# 目次

[Frequency Response Estimatorブロックを用いたプラントモデルのシステム同定（シミュレーション）](analyze_FRE_data_simulation.mlx)


[Frequency Response Estimatorブロックを用いたプラントモデルのシステム同定（実験）](analyze_FRE_data_experiment.mlx)


[応答オプティマイザーを用いた制御応答最適化](optimize_control_response.mlx)

