% Initialization file for demo ssc_lithium_cell_1RC.mdl. Demo
% based on T. Huria, M. Ceraolo, J. Gazzarri, R. Jackey. "High Fidelity
% Electrical Model with Thermal Dependence for Characterization and
% Simulation of High Power Lithium Battery Cells," IEEE International
% Electric Vehicle Conference, March 2012
%
% Copyright 2012 The MathWorks, Inc.
numCells = 1;
% load('results_1RC_T')
load('Kokam_LUT_3RC')

%% Thermal Properties
% Cell dimensions and sizes
cell_thickness = 0.0084; %m
cell_width = 0.215; %m
cell_height = 0.220; %m

% Cell surface area
cell_area = 2 * (...
    cell_thickness * cell_width +...
    cell_thickness * cell_height +...
    cell_width * cell_height); %m^2

% Cell volume
cell_volume = cell_thickness * cell_width * cell_height; %m^3
%%
for idx = 1:numCells
%% Lookup Table Breakpoints

Battery(idx).SOC_LUT = SOC_LUT;
Battery(idx).Temperature_LUT = [5 20 40] + 273.15;

%% Em Branch Properties (OCV, Capacity)

% Battery capacity
Battery(idx).Capacity_LUT = Capacity; %Ampere*hours

% Em open-circuit voltage vs SOC rows and T columns
Battery(idx).Em_LUT = [ results.T5C(:,1) ...
                        results.T20C(:,1) ...
                        results.T40C(:,1)]; %Volts

%% Terminal Resistance Properties

% R0 resistance vs SOC rows and T columns
Battery(idx).R0_LUT = [ results.T5C(:,2) ...
                        results.T20C(:,2) ...
                        results.T40C(:,2)]; %Ohms

%% RC Branch 1 Properties

% R1 Resistance vs SOC rows and T columns
Battery(idx).R1_LUT = [ results.T5C(:,3) ...
                        results.T20C(:,3) ...
                        results.T40C(:,3)]; %Ohms

% R2 Resistance vs SOC rows and T columns
Battery(idx).R2_LUT = [ results.T5C(:,4) ...
                        results.T20C(:,4) ...
                        results.T40C(:,4)]; %Ohms

% R3 Resistance vs SOC rows and T columns
Battery(idx).R3_LUT = [ results.T5C(:,5) ...
                        results.T20C(:,5) ...
                        results.T40C(:,5)]; %Ohms

% C1 Capacitance vs SOC rows and T columns
Battery(idx).C1_LUT = [ results.T5C(:,6) ...
                        results.T20C(:,6) ...
                        results.T40C(:,6)]; %Farads

% C2 Capacitance vs SOC rows and T columns
Battery(idx).C2_LUT = [ results.T5C(:,7) ...
                        results.T20C(:,7) ...
                        results.T40C(:,7)]; %Farads

% C3 Capacitance vs SOC rows and T columns
Battery(idx).C3_LUT = [ results.T5C(:,8) ...
                        results.T20C(:,8) ...
                        results.T40C(:,8)]; %Farads

%% Cell mass
Battery(idx).cell_mass = 0.86; %kg

% Volumetric heat capacity
% assumes uniform heat capacity throughout the cell
% ref: J. Electrochemical Society 158 (8) A955-A969 (2011) pA962
Battery(idx).cell_rho_Cp = 2.04E6; %J/m3/K

% Specific Heat
Battery(idx).cell_Cp_heat = Battery(idx).cell_rho_Cp * cell_volume / Battery(idx).cell_mass; %J/kg/K

%% Initial Conditions

% Ambient Temperature
Battery(idx).T_init = 20 + 273.15; %K

% Initial charge deficit
Battery(idx).Qe_init = 0.5 * mean(Capacity); %Ampere*hours

end

% Battery(1).Qe_init = 5; %Ampere*hours
% Battery(2).Qe_init = 8; %Ampere*hours

% Convective heat transfer coefficient
% For natural convection this number should be in the range of 5 to 25
h_conv = 5; %W/m^2/K Cell-to-cell
h_conv_end = 10; %W/m^2/K End cells to ambient

